<?php
// Pastikan koneksi $mysqli dan variabel $slug sudah terdefinisi sebelumnya

// Memeriksa apakah slug tidak kosong
if (!empty($slug)) {
    // Query untuk mendapatkan detail berdasarkan slug
    $queryaliantbankorg = "SELECT id, slug, hehe1, hehe2, hehe3, judul, description0, description1, template, keywords, keywords2, testi FROM aliantbankorg WHERE slug = ?";
    $stmtaliantbankorg = $mysqli->prepare($queryaliantbankorg);
    
    if ($stmtaliantbankorg) {
        $stmtaliantbankorg->bind_param("s", $slug);
        $stmtaliantbankorg->execute();
        $resultaliantbankorg = $stmtaliantbankorg->get_result();

        if ($resultaliantbankorg->num_rows > 0) {
            $rowaliantbankorg = $resultaliantbankorg->fetch_assoc();
            $id = $rowaliantbankorg['id'];
            $slug = $rowaliantbankorg['slug'];
            $hehe1 = $rowaliantbankorg['hehe1'];
            $hehe2 = $rowaliantbankorg['hehe2'];
            $hehe3 = $rowaliantbankorg['hehe3'];
            $judul = $rowaliantbankorg['judul'];
            $description0 = $rowaliantbankorg['description0'];
            $description1 = $rowaliantbankorg['description1'];
            $testi = $rowaliantbankorg['testi'];
            $keywords = $rowaliantbankorg['keywords']; 
            $keywords2 = $rowaliantbankorg['keywords2'];

            // Query untuk mendapatkan template acak
            $queryRandomaliantbankorg = "SELECT template 
                                FROM aliantbankorg 
                                WHERE id >= (SELECT FLOOR(RAND() * (SELECT MAX(id) FROM aliantbankorg))) 
                                ORDER BY id LIMIT 1";
            $resultRandomaliantbankorg = $mysqli->query($queryRandomaliantbankorg);

            if ($resultRandomaliantbankorg && $resultRandomaliantbankorg->num_rows > 0) {
                $rowRandomaliantbankorg = $resultRandomaliantbankorg->fetch_assoc();
                $template = $rowRandomaliantbankorg['template'];
            } else {
                feedback404();
                exit; // Berhenti jika template tidak ditemukan
            }

            // Memastikan file template ada
            $templateFile = 'templates/' . $template . '/template.php';
            if (!file_exists($templateFile)) {
                feedback404();
                exit; // Berhenti jika file template tidak ditemukan
            }

            // Membuat URL
            $pxl = 'https://';

            $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https" : "http";
            $host = $_SERVER['HTTP_HOST'];
            $url = $scheme . '://' . $host . '/';

            // Menyertakan file template
            include $templateFile;
        } else {
            feedback404();
            exit; // Berhenti jika slug tidak ditemukan
        }

        $stmtaliantbankorg->close();
    } else {
        echo "Gagal menyiapkan pernyataan: " . $mysqli->error;
    }
} else {
    echo "Slug tidak boleh kosong.";
}
?>
