<?php
function feedback404()
{
    header("HTTP/1.0 404 Not Found");
    include "index.html";
    exit();
}

// Koneksi ke database
$mysqli = new mysqli("localhost", "expexp_ev-alpha", "M_[f1%lyZWWL.TDe", "expexp_1");

// Periksa koneksi
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Ambil slug dari parameter URL: id
$slug = isset($_GET['id']) ? $_GET['id'] : '';

// Pastikan slug tidak diakhiri dengan '/'
if (substr($slug, -1) !== '/') {
    feedback404();
}

// Hapus trailing slash untuk query DB
$slug = rtrim($slug, '/');

// Jika slug kosong, tampilkan halaman utama
if (empty($slug)) {
    include "index.html";
    exit();
}

// Query untuk ambil data berdasarkan slug
$query = "SELECT id, slug, hehe2, hehe3, kota, judul, description0, description1, template, keywords, keywords2, testi FROM terang WHERE slug = ?";
$stmt = $mysqli->prepare($query);
if (!$stmt) {
    die("Prepare failed: " . $mysqli->error);
}

$stmt->bind_param("s", $slug);
$stmt->execute();
$result = $stmt->get_result();

// Jika slug tidak ditemukan di database
if ($result->num_rows === 0) {
    feedback404();
}

// Ambil data dari hasil query
$row = $result->fetch_assoc();
$id = $row['id'];
$slug = $row['slug'];
$judul = $row['judul'];
$hehe2 = $row['hehe2'];
$hehe3 = $row['hehe3'];
$kota = $row['kota'];
$description0 = $row['description0'];
$description1 = $row['description1'];
$template = $row['template'];
$keywords = $row['keywords'];
$keywords2 = $row['keywords2'];
$testi = $row['testi'];

// Daftar template yang valid
$validTemplates = ['template1', 'template2', 'template3', 'template4', 'template5'];

// Validasi template
if (!in_array($template, $validTemplates)) {
    $template = $validTemplates[array_rand($validTemplates)];
}

// Cek apakah file template ada
$templateFile = __DIR__ . '/templates/' . $template . '/template.php';
if (!file_exists($templateFile)) {
    feedback404();
}

// Siapkan base URL pakai ?id=
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$urlBase = $scheme . '://' . $host . '/?id=';

// Siapkan URL dan variabel pengganti
$url = 'https://niacollective.org/';
$url3 = 'niacollective.org'; // Placeholder, bisa diisi kalau kamu mau
$homepage = 'aaaa'; // Placeholder, bisa diganti juga

$placeholders = ['{slug}', '{keywords}', '{keywords2}', '{url}', '{homepage}', '{kota}', '{hehe2}', '{hehe3}'];
$replacements = [$slug, $keywords, $keywords2, $url, $homepage, $kota, $hehe2, $hehe3];

// Ganti placeholder di judul dan deskripsi
$judul = str_replace($placeholders, $replacements, $judul);
$description0 = str_replace($placeholders, $replacements, $description0);
$description1 = str_replace($placeholders, $replacements, $description1);

// Data untuk digunakan di template
$data_to_display = [
    'id' => $id,
    'slug' => $slug,
    'judul' => $judul,
    'description0' => $description0,
    'description1' => $description1,
    'testi' => $testi,
    'hehe2' => $hehe2,
    'hehe3' => $hehe3,
    'kota' => $kota,
    'url' => $urlBase . urlencode($slug),
    'keywords' => $keywords,
    'keywords2' => $keywords2,
];

// Render halaman dengan template
include $templateFile;

// Tutup statement dan koneksi
$stmt->close();
$mysqli->close();
?>
