import os
import shutil
import random

# Nama subfolder untuk menyimpan semua folder
subfolder = 'upload'
source_webp_folder = r'C:\Users\ev\Pictures\webp\kumpulan webp'
already_moved_folder = r'C:\Users\ev\Pictures\webp\kumpulan webp\already'

# Buat subfolder jika belum ada
os.makedirs(subfolder, exist_ok=True)
os.makedirs(already_moved_folder, exist_ok=True)

# Baca data dari file dengan encoding yang tepat
with open('data.txt', 'r', encoding='utf-8') as f:
    data_lines = [line.strip() for line in f.readlines() if line.strip()]

with open('urls.txt', 'r', encoding='utf-8') as f:
    urls = [line.strip() for line in f.readlines() if line.strip()]

with open('swit.txt', 'r', encoding='utf-8') as f:
    swit_lines = [line.strip() for line in f.readlines() if line.strip()]

# Pastikan jumlah data, url, dan swit sesuai
if len(data_lines) != len(urls) or len(data_lines) != len(swit_lines):
    raise ValueError("Jumlah data di data.txt, urls.txt, dan swit.txt harus sama.")

# Proses setiap folder
for folder_name, url, swit_value in zip(data_lines, urls, swit_lines):
    # Buat folder tujuan di dalam subfolder
    target_folder = os.path.join(subfolder, folder_name)
    os.makedirs(target_folder, exist_ok=True)

    # Cari file .webp di folder sumber
    webp_files = [f for f in os.listdir(source_webp_folder) if f.endswith('.webp')]

    # Ambil satu gambar .webp secara acak jika ada
    if webp_files:
        random_webp_file = random.choice(webp_files)
        original_webp_path = os.path.join(source_webp_folder, random_webp_file)

        # Pindahkan gambar ke folder already
        dest_path = os.path.join(already_moved_folder, random_webp_file)
        shutil.move(original_webp_path, dest_path)

        # Salin dan ganti nama file menjadi image.webp di folder target
        target_webp_path = os.path.join(target_folder, 'image.webp')
        shutil.copy(dest_path, target_webp_path)
    else:
        print(f"Tidak ada file .webp yang ditemukan untuk folder '{folder_name}'.")

    # Salin seluruh isi folder 'amp', 'assets', dan 'templates'
    for folder in ['amp', 'assets', 'templates']:
        folder_path = os.path.join('.', folder)
        if os.path.exists(folder_path):
            shutil.copytree(folder_path, os.path.join(target_folder, folder), dirs_exist_ok=True)

    # Salin semua file (termasuk .php) dan ganti placeholder
    for file_name in os.listdir('.'):
        if os.path.isfile(file_name) and file_name not in ['data.txt', 'urls.txt', 'swit.txt', 'wewe.py']:  # Hanya file biasa
            target_file_path = os.path.join(target_folder, file_name)
            shutil.copy(file_name, target_file_path)

            # Ganti konten file, jika file tersebut HTML atau PHP
            if file_name.endswith(('.html', '.php')):  # Ganti placeholder pada file HTML dan PHP
                with open(target_file_path, 'r', encoding='utf-8') as file:
                    content = file.read()

                # Ganti placeholder dengan nilai yang sesuai
                content = content.replace('{datadata}', folder_name)  # Ganti dengan nama folder
                content = content.replace('{urls}', url)  # Ganti dengan URL yang sesuai
                content = content.replace('{swit}', swit_value)  # Ganti dengan nilai dari swit.txt

                # Simpan kembali konten yang telah diubah
                with open(target_file_path, 'w', encoding='utf-8') as file:
                    file.write(content)

    print(f"Folder '{folder_name}' telah selesai diproses.")

print("Proses semua folder selesai.")
