<?php
// Koneksi ke database
$mysqli = new mysqli("localhost", "penepen_penepen", "E3Zy^flIdl,&", "penepen_ev9");
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Template HTML untuk index.html (dengan redirect ke ?id=slug/)
$indexHtmlContent = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="refresh" content="0;url=?id=__SLUG__/" />
    <title>Redirecting...</title>
</head>
<body>
    <p>Redirecting to <a href="?id=__SLUG__/">?id=__SLUG__/</a></p>
</body>
</html>
HTML;

// Path ke file phising.txt
$txtFilePath = '/home/penepen/public_html/phising.txt';

// Cek apakah file phising.txt ada
if (file_exists($txtFilePath)) {
    $phisingList = file($txtFilePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $baseDir = $_SERVER['DOCUMENT_ROOT'];

    // Ambil slug dan kolom hehe2, hehe3 dari database
    $result = $mysqli->query("SELECT slug, hehe2, hehe3 FROM terang");
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $slug = $row['slug'];
            $hehe2 = $row['hehe2'];
            $hehe3 = $row['hehe3'];
            $slugPrefix = explode('-', $slug)[0];

            // Hanya buat folder jika salah satu cocok dengan isi phising.txt
            if (
                in_array($slugPrefix, $phisingList) ||
                in_array($hehe2, $phisingList) ||
                in_array($hehe3, $phisingList)
            ) {
                $folderPath = $baseDir . '/' . $slug;

                if (!file_exists($folderPath)) {
                    if (mkdir($folderPath, 0777, true)) {
                        $redirectHtml = str_replace('__SLUG__', $slug, $indexHtmlContent);
                        file_put_contents($folderPath . '/index.html', $redirectHtml);
                        echo "Folder '$slug' dan index.html dengan redirect berhasil dibuat.<br>";
                    } else {
                        echo "Gagal membuat folder '$slug'.<br>";
                    }
                } else {
                    echo "Folder '$slug' sudah ada.<br>";
                }
            }
        }
    } else {
        echo "Gagal mengambil data dari database: " . $mysqli->error . "<br>";
    }
} else {
    echo "File phising.txt tidak ditemukan di path: $txtFilePath<br>";
}

// Tutup koneksi
$mysqli->close();
?>
