<?php
// Koneksi ke database
$mysqli = new mysqli("localhost", "penepen_penepen", "E3Zy^flIdl,&", "penepen_ev9");

// Cek koneksi
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Ambil slug dari database
function getUrlsFromDatabase($mysqli) {
    $urls = [];
    $query = "SELECT slug FROM aliantbankorg"; // Ganti aliantbankorg dengan nama tabel sebenarnya
    $result = $mysqli->query($query);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $urls[] = $row['slug'];
        }
    }

    return $urls;
}

function generateSitemap($urls, $outputFile, $priority, $changefreq) {
    $xml = new SimpleXMLElement('<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"/>');
    $currentTime = date('c');
    shuffle($urls); // Optional: Acak urutan slug

    $basePath = "https://" . $_SERVER['HTTP_HOST'];

    foreach ($urls as $slug) {
        $urlElement = $xml->addChild('url');
        $loc = $basePath . "/?id=" . urlencode($slug) . "/"; // Sesuai pola .htaccess
        $urlElement->addChild('loc', htmlspecialchars($loc));
        $urlElement->addChild('lastmod', $currentTime);
        $urlElement->addChild('priority', $priority);
        $urlElement->addChild('changefreq', $changefreq);
    }

    $xml->asXML($outputFile);
}

function splitList($list, $size) {
    return array_chunk($list, $size);
}

function generateSitemapIndex($baseUrl, $numSitemaps, $outputFile) {
    $xml = new SimpleXMLElement('<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"/>');
    $currentTime = date('c');
    $basePath = rtrim($baseUrl, '/') . '/' . trim(dirname($_SERVER['PHP_SELF']), '/') . '/';

    for ($i = 1; $i <= $numSitemaps; $i++) {
        $sitemapElement = $xml->addChild('sitemap');
        $sitemapElement->addChild('loc', htmlspecialchars(rtrim($basePath, '/') . '/sitemap_' . $i . '.xml'));
        $sitemapElement->addChild('lastmod', $currentTime);
    }

    $xml->asXML($outputFile);
}

function generateRobotsTxt($baseUrl, $numSitemaps, $outputFile) {
    $basePath = rtrim($baseUrl, '/') . '/' . trim(dirname($_SERVER['PHP_SELF']), '/') . '/';
    
    $content = "User-agent: *\nAllow: /\n\n";
    $content .= "Sitemap: " . rtrim($basePath, '/') . "/sitemap_index.xml\n";

    for ($i = 1; $i <= $numSitemaps; $i++) {
        $content .= "Sitemap: " . rtrim($basePath, '/') . "/sitemap_$i.xml\n";
    }

    file_put_contents($outputFile, $content);
}

function main() {
    global $mysqli;
    
    $urls = getUrlsFromDatabase($mysqli);
    $chunkSize = 9998;
    $chunks = splitList($urls, $chunkSize);

    if (!empty($urls)) {
        $baseUrl = "https://" . $_SERVER['HTTP_HOST'];

        foreach ($chunks as $i => $chunk) {
            $outputFilePath = "sitemap_" . ($i + 1) . ".xml";
            generateSitemap($chunk, $outputFilePath, 1.0, 'daily');
            echo "Sitemap generated: $outputFilePath\n";
        }

        generateSitemapIndex($baseUrl, count($chunks), 'sitemap_index.xml');
        echo "Sitemap index generated: sitemap_index.xml\n";

        generateRobotsTxt($baseUrl, count($chunks), 'robots.txt');
        echo "robots.txt generated: robots.txt\n";
    } else {
        echo "No slugs found in database.\n";
    }

    $mysqli->close();
}

main();
?>
